// Secure chat client for Assignment 3

import java.util.*;
import java.io.*;
import java.net.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

public class SecureChatClient extends JFrame implements Runnable, ActionListener 
{	
	// Port that will connect us to the secure chat client
	public static final int PORT = 8765;

	ObjectInputStream myReader;
	ObjectOutputStream myWriter;
	JTextArea outputArea;
	JLabel prompt;
	JTextField inputField;
	String myName, serverName;
	Socket connection;

	// These will store the public and private keys recceived by the secure server
	private BigInteger N, E, D;

	// Holds the type of encryption generated by the server
	String encType = null;

	// Will hold the symetric cipher object
	SymCipher cipher = null;

	// Will hold the cipher's key
	BigInteger key = null;

	// Will hold user's encrypted name
	byte encryptedName[] = null;

	public SecureChatClient ()
	{
		try 
		{
			serverName = JOptionPane.showInputDialog(this, "Enter the server name: ");
			InetAddress addr =
					InetAddress.getByName(serverName);
			connection = new Socket(addr, PORT);   // Connect to server with new
					
			// Creates object output and input streams
			myWriter = new ObjectOutputStream(connection.getOutputStream());
			myWriter.flush();
		    myReader = new ObjectInputStream(connection.getInputStream());

		    // Grab the server's public key and mod value 
		  	E = (BigInteger)myReader.readObject();
		  	N = (BigInteger)myReader.readObject();

		  	// Grab the encryption type from the server
		  	encType = new String((String)myReader.readObject());

		  	// Output type of encryption to console based on what we get from the server
		  	// Create new Sub/Add128 objects to place in cipher
		  	if( encType.equals("Sub") ) 
		  	{
		  		System.out.println("Type of encryption: Substitute.");
		  	    cipher = new Substitute();
		  	}
		  	else 
		  	{
		  		System.out.println("Type of encryption: Add128.");
		  		cipher = new Add128();
		  	}

		  	// Create a big int representation of the cipher key
		  	key = new BigInteger(1, cipher.getKey());

		  	// Outputs the key to the console
		  	System.out.println("Key: " + key);

		  	// RSA encrypt your key and send it to the server
		 	myWriter.writeObject(key.modPow(E,N));
		 	myWriter.flush();

		 	// Ask the user for their name and encrypts
		 	myName = JOptionPane.showInputDialog(this, "Enter your user name: ");
		 	encryptedName = cipher.encode(myName);

		 	// Send user name to server
		 	myWriter.writeObject(encryptedName);
		 	myWriter.flush();

			this.setTitle(myName);	  // Set title to identify chatter

			Box b = Box.createHorizontalBox();  // Set up graphical environment for user
			outputArea = new JTextArea(8, 30);  
			outputArea.setEditable(false);
			b.add(new JScrollPane(outputArea));

			outputArea.append("Welcome to the Chat Group, " + myName + "\n");

			inputField = new JTextField("");  // This is where user will type input
			inputField.addActionListener(this);

			prompt = new JLabel("Type your messages below:");
			Container c = getContentPane();

			c.add(b, BorderLayout.NORTH);
			c.add(prompt, BorderLayout.CENTER);
			c.add(inputField, BorderLayout.SOUTH);

			Thread outputThread = new Thread(this);  // Thread is to receive strings
			outputThread.start();					// from Server

			addWindowListener(
					new WindowAdapter()
					{
						public void windowClosing(WindowEvent e)
						{ 
							try
							{
								// Give the closing signal to the server
								myWriter.writeObject(cipher.encode("CLIENT CLOSING"));
							}
							catch(Exception m)
							{
								System.out.println("Error closing client.");
							}
							finally
							{
								System.out.println("CLIENT CLOSING");
							 	System.exit(0);
							}
						}
					}
				);

			setSize(500, 200);
			setVisible(true);

		}
		catch (Exception e)
		{
			System.out.println(e + ". Problem starting client!");
		}
	}

	public void run()
	{
		while (true)
		{
			 try 
			 {
				byte currMsg[] = (byte[])myReader.readObject();
				
				// We decode the message and send it to be shown
				String decoded = cipher.decode(currMsg);
				outputArea.append(decoded+"\n");

				// Output data to the console
				System.out.println("BigInteger representation of byte array received: " + new BigInteger(1,currMsg) );
				System.out.println("BigInteger representation of decrypted byte array : " + new BigInteger(1,cipher.decode(currMsg).getBytes()));
			 	System.out.println("Corresponding string: " + decoded);
			 }
			 catch (Exception e)
			 {
				System.out.println(e +  ", closing client!");
				break;
			 }
		}
		System.exit(0);
	}

	public void actionPerformed(ActionEvent e)
	{	
		try
		{
			String currMsg = e.getActionCommand();	  // Get input value
			inputField.setText("");

			// We add user name to the message
			currMsg = myName + ":" + currMsg;

			// We encrypt the current message before sending it to the server
			myWriter.writeObject(cipher.encode(currMsg));   
			myWriter.flush();

			// Output data to the console
			System.out.println("Original string message: " + currMsg);
			System.out.println("BigInteger representation of byte array: " + new BigInteger(1,currMsg.getBytes()) );
			System.out.println("BigInteger representation of enrypted byte array : " + new BigInteger(1,cipher.encode(currMsg)));

			
		}
		catch (Exception g)
		
{			System.out.println("Something went wrong " + g);
		}
	}											 	

	public static void main(String [] args)
	{
		 SecureChatClient JR = new SecureChatClient();
		 JR.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
	}
}


